<?php defined('SYSPATH') or die('No direct script access.');

class Task_Serverstats_Update_CountClientsDbEstimate extends Minion_Task
{
    
    const UPDATE_PERIOD = 60;
    
	protected function _execute(array $params)
    {
        Task_Helper::createWorker('Serverstats:Update:CountClientsDbEstimate', $this);
	}

    public function Worker(GearmanJob $job)
    {
        $serverstat = ORM::factory('Serverstat', 'CountClientsDbEstimate');
        
        if ( null === $serverstat->updated_at || time() - strtotime($serverstat->updated_at) > self::UPDATE_PERIOD )
        {
            $countClientsDbEstimate = Helper::countRowsEstimated('clients');
            $platform = preg_replace('/^mysqli$/', 'mysql', strtolower(Kohana::$config->load('database.' . Database::$default . '.type')));

            Model_Serverstat::setStat('CountClientsDbEstimate', $countClientsDbEstimate, array(':platform' => $platform));
        }
    }
    
}